



<html>
<head>
  <title>javabog.dk -  - Flertr&aring;det programmering</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel16.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel18.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">17 <a name='afsn17'></a>Flertr&aring;det
programmering</H1>
<P CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI><P CLASS="kapiteloversigt-western">Forst&aring; tr&aring;de</P>
  <LI><P CLASS="kapiteloversigt-western">Eksempel p&aring; en
  flertr&aring;det webserver</P>
</UL>
<P CLASS="kapiteloversigt-western">Kapitlet foruds&aelig;ttes ikke i
resten af bogen.</P>
<P CLASS="kapiteloversigt-western">Foruds&aelig;tter <a href='kapitel12.jsp'>kapitel 12</a>, Interfaces
(<a href='kapitel16.jsp'>kapitel 16</a>, Netv&aelig;rkskommunikation og <a href='kapitel9.jsp'>kapitel 9</a>, Grafiske programmer
bruges i nogle eksempler).</P>


<P CLASS="western" STYLE="">N&aring;r man
kommer ud over den grundl&aelig;ggende programmering, &oslash;nsker
man tit at lave  programmer, som udf&oslash;rer flere opgaver
l&oslash;bende. Det kan f.eks. v&aelig;re et
tekstbehandlingsprogram, hvor man &oslash;nsker at kunne gemme
eller udskrive i baggrunden, mens brugeren redigerer videre,
eller man &oslash;nsker l&oslash;bende stavekontrol samtidig med, at
brugeren skriver. Skrivningen m&aring; ikke blive forsinket af,
at programmet sidel&oslash;bende forbereder en udskrift eller
kontrollerer stavningen. Disse delprocesser (kaldet tr&aring;de) har
lav prioritet i forhold til at h&aring;ndtere brugerens input og vise
det p&aring; sk&aelig;rmen og selvom de midlertidigt skulle g&aring;
i st&aring;, skal de andre dele af programmet k&oslash;re videre.</P>
<P CLASS="western">Et flertr&aring;det program er et program med
flere tilsyneladende samtidige programudf&oslash;relsespunkter
(i virkeligheden vil CPU'en skifte meget hurtigt rundt mellem
punkterne og udf&oslash;re lidt af hver).</P>
<H2 CLASS="western">17.1 <a name='afsn17.1'></a>Princip</SPAN></H2>
<P CLASS="western">Det er ret let at programmere flere tr&aring;de i
Java. Man opretter en ny tr&aring;d med et objekt i konstrukt&oslash;ren:</P>
<PRE CLASS="kode-western">  Thread tr&aring;d;
  tr&aring;d = new Thread(obj);</PRE><P CLASS="western">
Objektet obj skal implementere interfacet Runnable, f.eks.:</P>
<PRE CLASS="ikke-javakode-western">public class Udf&oslash;rbartObjekt <B>implements Runnable</B>
{
  <B>public void run()</B>  <I>// <SPAN STYLE="font-weight: medium">kr&aelig;ves af Runnable</SPAN></I>
  {
<I>    // her starter den nye tr&aring;d med at k&oslash;re</I>
<I>    // ...</I>
  }
}</PRE><P CLASS="western">
Tr&aring;den er nu klar til at udf&oslash;re run()-metoden p&aring;
objektet, men den er ikke startet endnu. Man starter den ved at kalde
start()-metoden p&aring; tr&aring;d-objektet:</P>
<PRE CLASS="kode-western">  tr&aring;d.start();
<I>  // her k&oslash;rer den oprindelige tr&aring;d videre, mens den nye tr&aring;d k&oslash;rer i obj.run()</I>
<I>  // ...</I></PRE><P CLASS="western">
Derefter vil der v&aelig;re to programudf&oslash;relsespunkter: Et
vil v&aelig;re i koden efter kaldet til start() og den anden vil v&aelig;re
ved begyndelsen af run()-metoden i objektet.</P>
<P CLASS="western" ALIGN=CENTER> 
<IMG SRC="bog18_html_m34c5d39f.gif" NAME="Objekt19" ALIGN=MIDDLE></P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>En
tr&aring;d oprettes med et objekt, der implementerer
Runnable-interfacet. <BR>N&aring;r start() kaldes p&aring; tr&aring;den,
vil den begynde at udf&oslash;re run() p&aring; objektet.</I></FONT></P>

<H3 CLASS="western">17.1.1 <a name='afsn17.1.1'></a>Eksempel</H3>
<P CLASS="western">Herunder definerer vi klassen SnakkesagligPerson.
Objekter af typen SnakkesaligPerson kan k&oslash;re i en tr&aring;d
(implements Runnable). I konstrukt&oslash;ren angives navnet p&aring;
personen og hvor lang tid der g&aring;r, mellem at personen taler. 
</P>
<P CLASS="western">N&aring;r run() udf&oslash;res, skriver den
personens navn + bla bla bla ud, s&aring; ofte som angivet.</P>
<PRE CLASS="kode-western" STYLE="">public class SnakkesagligPerson <B>implements Runnable</B>
{
  private String navn;
  private int ventetid;

  public SnakkesagligPerson(String n, int t)
  {
    navn = n;
    ventetid = t;
  }

<B>  public void run()</B>
  {
    for (int i=0; i&lt;5; i++)
    {
      System.out.println(navn+&quot;: bla bla bla &quot;+i);
      try {  Thread.sleep(ventetid); } catch (Exception e) {} <I>// vent lidt</I>
    }
  }
}</PRE><P CLASS="western">
Da Thread.sleep() kan kaste undtagelser af typen
InterruptedException, er vi n&oslash;dt til at indkapsle koden i en
try-catch-blok (denne undtagelse forekommer aldrig i praksis).</P>
<P CLASS="western">Vi kan nu oprette en snakkesalig person, der siger
noget hvert sekund:</P>
<PRE CLASS="kode-western">    SnakkesagligPerson p = new SnakkesagligPerson(&quot;Brian&quot;,1000);</PRE><P CLASS="western">
... og en tr&aring;d, der er klar til at udf&oslash;re p.run() og
lade personen snakke:</P>
<PRE CLASS="kode-western">    Thread t = new Thread(p); </PRE><P CLASS="western">
... og til sidst startes tr&aring;den, s&aring; personen snakker:</P>
<PRE CLASS="kode-western">    t.start();</PRE>
<P CLASS="western">Her ses et samlet eksempel, der opretter 3
snakkesalige personer, Jacob, Troels og Henrik og lader dem snakke i
munden p&aring; hinanden (i hver sin tr&aring;d). 
</P>
<PRE CLASS="kode-western">public class BenytSnakkesagligePersoner
{
  public static void main(String[] arg)
  {
    SnakkesagligPerson<B> p = new SnakkesagligPerson(&quot;Jacob&quot;,150)</B>;
    Thread <B>t = new Thread(p)</B>; <I>// Ny tr&aring;d, klar til at udf&oslash;re p.run()</I>
    <B>t.start()</B>; <I>// .. Nu starter personen med at snakke...</I>

    p = new SnakkesagligPerson(&quot;Troels&quot;,400);
    t = new Thread(p);
    t.start();

<I>    // Det kan ogs&aring; g&oslash;res meget kompakt:</I>
<B>    new Thread(new SnakkesagligPerson(&quot;Henrik&quot;,200)).start();</B>
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Jacob: bla bla bla 0
Troels: bla bla bla 0
Henrik: bla bla bla 0
Jacob: bla bla bla 1
Henrik: bla bla bla 1
Jacob: bla bla bla 2
Troels: bla bla bla 1
Henrik: bla bla bla 2
Jacob: bla bla bla 3
Henrik: bla bla bla 3
Jacob: bla bla bla 4
Troels: bla bla bla 2
Henrik: bla bla bla 4
Troels: bla bla bla 3
Troels: bla bla bla 4</PRE><P CLASS="western">
Bem&aelig;rk, at udf&oslash;relsen af main(), der faktisk sker i en
fjerde tr&aring;d, afsluttes med det samme, men at programmet
k&oslash;rer videre, indtil de tre tr&aring;de er f&aelig;rdige med
deres opgaver; Java forts&aelig;tter med at udf&oslash;re et program,
s&aring; l&aelig;nge der er tr&aring;de, der stadig er aktive, dvs.
ikke har returneret fra run().</P>
<H2 CLASS="western">17.2 <a name='afsn17.2'></a>Ekstra eksempler</SPAN></H2>
<P CLASS="western">Se <a href='kapitel9.jsp#afsn9.4.2'>afsnit 9.4.2</a>, Animationer med en separat tr&aring;d,
for et eksempel p&aring; et grafisk program med flere tr&aring;de.</P>
<H3 CLASS="western">17.2.1 <a name='afsn17.2.1'></a>En flertr&aring;det webserver</H3>
<P CLASS="western">Herunder har vi lavet en flertr&aring;det
webserver (sammenlign med Hjemmesidevaert i <a href='kapitel16.jsp'>kapitel 16</a>). For at g&oslash;re
det nemmere at se, hvad der foreg&aring;r, lader vi hver anmodning
vente i 10 sekunder, f&oslash;r den afslutter. 
</P>
<PRE CLASS="kode-western">import java.io.*;
import java.net.*;
import java.util.*;

public class Anmodning <B>implements Runnable</B>
{
<B>  private Socket forbindelse;</B>

  Anmodning(Socket forbindelse)
  {
    this.forbindelse = forbindelse;
  }

<B>  public void run()</B>
  {
    try {
      PrintWriter ud = new PrintWriter(<B>forbindelse.getOutputStream()</B>);
      BufferedReader ind = new BufferedReader(
        new InputStreamReader(<B>forbindelse.getInputStream()</B>));

      String anmodning = ind.readLine();
      System.out.println(&quot;start &quot;+new Date()+&quot; &quot;+anmodning);

      ud.println(&quot;HTTP/0.9 200 OK&quot;);
      ud.println();
      ud.println(&quot;&lt;html&gt;&lt;head&gt;&lt;title&gt;Svar&lt;/title&gt;&lt;/head&gt;&quot;);
      ud.println(&quot;&lt;body&gt;&lt;h1&gt;Svar&lt;/h1&gt;&quot;);
      ud.println(&quot;T&aelig;nker over &quot;+anmodning+&quot;&lt;br&gt;&quot;);
      for (int i=0; i&lt;100; i++) 
      {
        ud.print(&quot;.&lt;br&gt;&quot;);
        ud.flush();
        Thread.sleep(100);
      }
      ud.println(&quot;Nu har jeg t&aelig;nkt f&aelig;rdig!&lt;/body&gt;&lt;/html&gt;&quot;);
      ud.flush();
      forbindelse.close();
      System.out.println(&quot;slut  &quot;+new Date()+&quot; &quot;+anmodning);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}</PRE>
<P CLASS="western">N&aring;r der kommer en anmodning, oprettes et
Anmodning-objekt, der snakker med klienten og behandler foresp&oslash;rgslen
og en ny tr&aring;d knyttes til anmodningen.</P>
<PRE CLASS="kode-western" STYLE="">import java.io.*;
import java.net.*;
public class FlertraadetHjemmesidevaert
{
  public static void main(String[] arg)
  {
    try {
      ServerSocket <B>v&aelig;rtssokkel = new ServerSocket(8001)</B>;

      while (true)
      {
        Socket <B>forbindelse = v&aelig;rtssokkel.accept()</B>;
        Anmodning <B>a = new Anmodning(forbindelse)</B>;
        <B>new Thread(a).start()</B>;
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western"><B>start</B> Tue Nov 28 15:37:31 GMT+01:00 2000 GET /xx.html HTTP/1.0
<B>start</B> Tue Nov 28 15:37:38 GMT+01:00 2000 GET /yy.html HTTP/1.0
<B>start</B> Tue Nov 28 15:37:42 GMT+01:00 2000 GET /zz.html HTTP/1.0
<B>slut</B>  Tue Nov 28 15:37:42 GMT+01:00 2000 GET /xx.html HTTP/1.0
<B>slut</B>  Tue Nov 28 15:37:49 GMT+01:00 2000 GET /yy.html HTTP/1.0
<B>start</B> Tue Nov 28 15:37:50 GMT+01:00 2000 GET /qq.html HTTP/1.0
<B>slut</B>  Tue Nov 28 15:37:53 GMT+01:00 2000 GET /zz.html HTTP/1.0
<B>slut</B>  Tue Nov 28 15:38:01 GMT+01:00 2000 GET /qq.html HTTP/1.0</PRE><P CLASS="western">
Programmet er afpr&oslash;vet ved at &aring;bne adressen
<A CLASS="western" HREF="http://localhost:8001/xx.html">http://localhost:8001/xx.html</A>
 hhv. yy, zz og qq.html i en netl&aelig;ser. Man ser, at
anmodningerne xx, yy og zz behandles samtidigt.</P>
<H3 CLASS="western">17.2.2 <a name='afsn17.2.2'></a>Et flertr&aring;det program med hoppende
bolde</H3>
<P CLASS="western">Lad os lave et program med nogle bolde, der hopper
rundt. Hver bold k&oslash;rer i sin egen tr&aring;d.</P>
<P CLASS="western">N&aring;r en bold oprettes, f&aring;r den i
konstrukt&oslash;ren overf&oslash;rt start-koordinater og et
Graphics-objekt, som den husker. Den opretter og starter en tr&aring;d,
som k&oslash;rer run()-metoden.</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog18_html_5724bbaf.png" NAME="Grafik19" ALIGN=MIDDLE BORDER=0></P>
<P CLASS="western">Vi kan s&aring; oprette et vindue, f&aring; dets
Graphics-objekt og oprette nogle bolde med det, som vist herunder: 
</P>
<PRE CLASS="kode-western">import java.awt.*;

public class FlertraadetGrafik
{
  public static void main(String[] arg)
  {
    Frame f = new Frame();
    f.setSize(400,150);
    f.setBackground(Color.WHITE);
    f.setVisible(true);
    Graphics g = f.getGraphics();
    new Bold(g,  0, 0);
    new Bold(g, 50,10);
    new Bold(g,100,50);
    new Bold(g,150,90);
  }
}</PRE>
<PRE CLASS="kode-western">import java.awt.*;

public class Bold implements Runnable
{
  double x, y, fartx, farty;
  Graphics g;

  public Bold(Graphics g1, int x1, int y1)
  {
    g = g1;
    x = x1;
    y = y1;

    fartx = Math.random();
    farty = Math.random();
<B>    Thread t = new Thread(this);</B>
<B>    t.start();</B>
  }

  public void run()
  {
    for (int tid=0; tid&lt;5000; tid++)
    {
<I>      // Tegn bolden over med hvid p&aring; den gamle position</I>
      g.setColor(Color.WHITE);
      g.drawOval((int) x, (int) y, 50, 50);

<I>      // Opdater positionen med farten</I>
      x = x + fartx;
      y = y + farty;

<I>      // Tegn bolden med sort p&aring; den nye position</I>
      g.setColor(Color.BLACK);
      g.drawOval((int) x, (int) y, 50, 50);

<I>      // &aelig;ndr boldens hastighed lidt nedad</I>
      farty = farty + 0.1;

      <I>// Hvis bolden er uden for det tilladte omr&aring;de skal den</I>
<I>      // rettes hen mod omr&aring;det</I>
      if (x &lt; 0) fartx = Math.abs(fartx);
      if (x &gt; 400) fartx = -Math.abs(fartx);
      if (y &lt; 0) farty = Math.abs(farty);
      if (y &gt; 100) farty = -Math.abs(farty);

<I>      // Vent lidt</I>
      try { Thread.sleep(10); } catch (Exception e) {};
    }
  }
}</PRE>

<H2 CLASS="western">17.3 <a name='afsn17.3'></a>Opgaver</SPAN></H2>
<OL>
  <LI><P CLASS="western">Udvid FlertraadetGrafik med andre figurer end
  bolde.</P>
  <LI><P CLASS="western">Skriv et program, der udregner primtal (se
  <a href='kapitel2.jsp'>kapitel 2</a> for inspiration). Samtidig med, at programmet regner, skal
  det kunne kommunikere med brugeren og give ham mulighed for at
  afslutte programmet og udskrive de primtal, der er fundet indtil nu.</P>
</OL>

<H2 CLASS="western" STYLE="">17.4 <a name='afsn17.4'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel17.jsp#afsn17.4">
  <input type='checkbox' name='vis' value='17.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='17.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">17.4.1 <a name='afsn17.4.1'></a>Nedarvning fra Thread</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel17.jsp#afsn17.4.1">
  <input type='checkbox' name='vis' value='17.4.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='17.4.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">17.4.2 <a name='afsn17.4.2'></a>Synkronisering</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel17.jsp#afsn17.4.2">
  <input type='checkbox' name='vis' value='17.4.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='17.4.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">17.4.3 <a name='afsn17.4.3'></a>Synkronisering p&aring; objekter og
semaforer</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel17.jsp#afsn17.4.3">
  <input type='checkbox' name='vis' value='17.4.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='17.4.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
17.4.4 <a name='afsn17.4.4'></a>wait() og notify()</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel17.jsp#afsn17.4.4">
  <input type='checkbox' name='vis' value='17.4.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='17.4.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">17.4.5 <a name='afsn17.4.5'></a>Prioritet</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel17.jsp#afsn17.4.5">
  <input type='checkbox' name='vis' value='17.4.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='17.4.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">17.4.6 <a name='afsn17.4.6'></a>Opgaver</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel17.jsp#afsn17.4.6">
  <input type='checkbox' name='vis' value='17.4.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='17.4.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>Egentligt
  sker det med konstruktionen synchronized (this), som er beskrevet i
  n&aelig;ste afsnit.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel16.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel18.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (82% af vrket).
</font>
<br>
nsker du at se de sidste 18% af dette vrk (199974 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
